$TITLE CPE2C Cobb-Douglas consumer model
*Programmed by Hans Lofgren, IFPRI, November 1999.

SET

 C  commodities
    /AGR-C  agricultural commodity,
     NAGR-C  non-agricultural commodity/

 H  households
    /HH-U    urban,
     HH-NONU   non urban/
    ;
ALIAS(C,CP),(H,HP);
*ALIAS(H,HP);

TABLE CONSVAL(C,H)
                 HH-U       HH-NONU
 AGR-C            50           75
 NAGR-C          100           50
    ;

PARAMETER
 INCOME(H) base-year income or expenditure (LCU)
 ;
 INCOME(H) = SUM((C), CONSVAL(C,H));

DISPLAY INCOME;

PARAMETERS
 beta(C,H)   share of h-hold consumption spending on commodity c
 p(C)        market price of commodity c (LCU)
 yh(H)       household income (LCU)
 ;


VARIABLE
 QH(C,H)     quantity of household consumption of c (base-year LCU)
 ;

EQUATION
 HHDEM(C,H)  consumption demand for commodity c
 ;
 HHDEM(C,H)..   QH(C,H) =E= beta(C,H)*yh(H)/p(C);



MODEL
 CPE2C Cobb-Douglas consumer model
 /HHDEM/
 ;

*================================================
*CALIBRATION=====================================
*================================================

PARAMETERS

*Parameter used to define initial variable levels.
 QH0(C,H)    quantity of household consumption of c (base-year LCU)


*Parameter used to define base values that are changed in simulations.
 P0(C)       base market price of commodity c (LCU)
 ;

 P0(C)  = 1;
 P0('AGR-C')=1.1;

 p(C)   = P0(C);

 yh(H)     = INCOME(H);

 beta(C,H)  = CONSVAL(C,H)/SUM(CP, CONSVAL(CP,H));

 QH0(C,H) = CONSVAL(C,H)/p(C);

*Initializing variables
 QH.L(C,H)  = QH0(C,H);



*================================================
*SOLVING FOR BASE================================
*================================================

SOLVE CPE2C USING MCP;

DISPLAY
 P0, p, yh, beta, QH0, QH.L;